function [lb_val,ub_val,best_sol] = milpFitLin(X,y,th,M,maxtime,verb,Xk,yk)
    N = size(X,1);
    p = size(X,2);
    
    M_N = M*ones(N,1);

    f = [zeros(p,1);
          ones(N,1)];
    A = [ X -diag(M_N);
         -X -diag(M_N)];
    b = [th+y;
         th-y];
     
    if ~isempty(Xk) && ~isempty(yk)
        A = [      A       ;
              Xk zeros(1,N);
             -Xk zeros(1,N)];
        b = [  b  ;
             th+yk;
             th-yk];
    end
     
    model.A = sparse(A);
    model.obj = f;
    model.rhs = b;
    if ~isempty(Xk) && ~isempty(yk)
        model.sense = repmat('<',2*N+2,1);
    else
        model.sense = repmat('<',2*N,1);
    end
    model.vtype = [repmat('C',p,1);
                   repmat('B',N,1)];
    model.lb = [ -Inf(p,1);
                zeros(N,1)];
    model.ub = [  Inf(p,1);
                 ones(N,1)];
    model.modelsense = 'min';
    
    params.outputflag = verb;
    params.Cuts = 3;
    params.Threads = 4;
    params.TimeLimit = maxtime;
%     params.IntFeasTol = 1e-9;
%     params.FeasibilityTol = 1e-9;
%     params.OptimalityTol = 1e-9;
    
    result = gurobi(model,params);
    
    if strcmp(result.status,'INFEASIBLE')
        lb_val = NaN;
        ub_val = NaN;
        best_sol = NaN(p,1);
    else
        lb_val = result.objbound;
        ub_val = result.objval;
        best_sol = result.x(1:p);
    end
end