% dependency: randomsample.m
function [min_outlier_count,curr_best_theta] = ransac(A,b,th,iter)
    N = size(A,1); % number of points
    d = size(A,2); % numer of dimensions
    
    thetas    = zeros(d,iter);
    residuals = zeros(N,iter);
    for i = 1:iter
        indices = genCandidateSet(A,N,d);
        
        thetas(:,i) = regress(b(indices,1), A(indices,:));
        
        residuals(:,i) = abs(A*thetas(:,i) - b);
    end
    outlier_counts = sum(residuals > th);
    [min_outlier_count,i] = min(outlier_counts);
    curr_best_theta = thetas(:,i);

end

% Attempt to generate a candidate set of n random points to perform linear
% regression.
% Once a random candidate set is generated the function will evaluate if 
% the matrix formed using the candidate set is well-conditioned. If not, it
% will move on to try a different candidate set.
function indices = genCandidateSet(A,N,d)
    failed_count = 0;
    while failed_count < 10000
        indices = randomsample(N,d);
        Asub = A(indices,:);
        if rcond(Asub'*Asub) >= 100*eps
            return;
        end
%         warning('Encountered ill-conditioned candidate set during ransac run');
    end
end