function displayResults(images,p,TERs)


% The indices in which the correspondence is given.
corrIdx = find(p(1,:) > 0);


% for each image, plot appropriately.
for imIdx = 1:size(images,2)
    
    % Start by plotting the image
    figure(); 
    imshow(images{imIdx}.image);
    hold on;
    title(images{imIdx}.imageName);
    
    % If this image has a correspondence, plot it.
    if ~isempty(find(imIdx == corrIdx, 1))
        
        plot(p(1,imIdx),p(2,imIdx),'gp','markersize',10,...
            'markerfacecolor','y');
        
    else
        
        %% Plot the epipolar lines
        epi = TERs{imIdx}.lineInfo.epi;

        for eLine = 1:size(epi,2)
            plot3(epi(eLine).x,epi(eLine).y,[5,5],...
                'color',epi(eLine).color,...
                'linewidth',epi(eLine).linewidth);
        end
               
        %% Plot the feature points
        % Only plot the feature points if they are given.
        if isfield(images{imIdx},'f')
            plot(images{imIdx}.f(1,:),images{imIdx}.f(2,:),'gs');
        end
        
        %% Plot the TERs themselves.
        % Get the faces and vertices of the invalid region
        [f,v] = poly2fv(TERs{imIdx}.regions.invalid(1,:),...
            TERs{imIdx}.regions.invalid(2,:));
        v(:,3) = 2; % Move to the back so everything else plots on top patches.
        
        % Create the patch
        patch('faces',f,'vertices',v,'facecolor',[0.8 0.3 0.3],'edgecolor','none');
 
    end
    
end

end