function imageNames = getImagesInDir(dirPath)
% imageNames = getImagesInDir(dirPath)
%
% Author: Mor Dar
% Last Change: April 4, 2016
%
% This function filters out and returns only the names of the images in the
% given directory path.

imageNames = {};
imageFiles = dir([dirPath '/*.*']);

% for each file
for index = 1:length(imageFiles)
    
    % Get the file name and extract the extension
    baseFileName = imageFiles(index).name;
    [~, ~, extension] = fileparts(baseFileName);
    extension = upper(extension);
    
    % If it is an image save it to the file name array.
    switch lower(extension)
        case {'.png', '.bmp', '.jpg', '.tif'}
        % Allow only PNG, TIF, JPG, or BMP images
       
        imageNames{end+1} = baseFileName;
        
        otherwise % do nothing
    end
end