function [epiIntersects, parIntersects] = getRelevantIntersections(corrIdxs, imageIdx, lineInfo)
% [epiIntersects, parIntersects] = getRelevantIntersections(corrIdxs, imageIdx, lineInfo)
%
% Author: Mor Dar
% Last Change: April 4, 2016
%
% This function returns only the intersections using the epipolar lines in
% the given subset of epipolar lines.  


%% Initialize some variables.
% get the 3 lines without the point in order.
lineLabels = order(order ~= pLabel);

% get the ids for the epipolar lines corresponding to these lines.
epiIds = zeros(size(lineLabels));
for idx = 1:size(epiIds,2)
    index = find(lineLabels(idx) == [lineInfo.epi.label],1);
    epiIds(idx) = lineInfo.epi(index).id;
end

% Get the ids for the parallel lines which originate from one of the three
% epipolar ids and are parallel to one of the three epipolar ids.
parToEpiId = [lineInfo.par.epiId];
temp = [lineInfo.par.fromIntersectionsOfEpiIds];
parIntersectId(1,:) = temp(1:2:end);
parIntersectId(2,:) = temp(2:2:end);

% label each good one as 0
for idx = 1:size(epiIds,2)
    parToEpiId(parToEpiId == epiIds(idx)) = 0;
    parIntersectId(parIntersectId == epiIds(idx)) = 0;
end
parIds = find(parToEpiId == 0 & sum(parIntersectId,1) == 0);

%% Get the line handles.
% Extract the line handles with the appropriate id. Note: as epiIds is
% created using time order, the line handles are set in time order as well.
for idx = 1:size(epiIds,2)
    lineHandles(idx) = lineInfo.epi([lineInfo.epi.id] == epiIds(idx));
end

% Extract the parallel line handles with the appropriate id. 
for idx = 1:size(parIds,2)
    parlineHandles(idx) = lineInfo.par([lineInfo.par.id] == parIds(idx));
end

%% Get the intersection information.
% Get the intersections which correspond to the epiIds
epiIntersectIds = [lineInfo.epiIntersects.ids];
for idx = 1:size(epiIds,2)
    epiIntersectIds(epiIntersectIds == epiIds(idx)) = 0;
end
epiIntersects = lineInfo.epiIntersects(sum(epiIntersectIds,1) == 0);
    
% Add the line labels to the intersect information.
for idx = 1:size(epiIntersects,2)
    epiIntersects(idx).labels(1) = lineHandles([lineHandles.id] == epiIntersects(idx).ids(1)).label; 
    epiIntersects(idx).labels(2) = lineHandles([lineHandles.id] == epiIntersects(idx).ids(2)).label;
end

% Get the parallel intersections which correspond to the parIds
parIntersectIds = [lineInfo.parIntersects.ids];
for idx = 1:size(parIds,2)
    parIntersectIds(parIntersectIds == parIds(idx)) = 0;
end
parIntersects = lineInfo.parIntersects(sum(parIntersectIds,1) == 0);

% Add the line labels to the intersect information.
for idx = 1:size(parIntersects,2)
    parIntersects(idx).labels(1) = parlineHandles([parlineHandles.id] == parIntersects(idx).ids(1)).label; 
    parIntersects(idx).labels(2) = parlineHandles([parlineHandles.id] == parIntersects(idx).ids(2)).label;
end