function invalidTERs = lookUpInvalidTERs(imageLoc, lineIdxs)
% invalidTERs = lookUpInvalidTERs(imageLoc, lineIdxs)
%
% Author: Mor Dar
% Last Change: April 4, 2016
%
% This  function acts as a table.  Given 4 images u,i,j,k, determine which
% TERs are invalid depending on the location of u in the order.  In this
% case imageLoc is 1-4 determining the position of u in the time order, and
% i,j,k use the indices of the line in the time order.

% initialize invalidTERs
invalidTERs = cell(1,8);

switch imageLoc
    case 1
        % The invalid regions are: 
        % R1, R2(j,k), R3(j, i', k'), R3(k, i', j'), R4(i', j'),
        % R5(i,i',j'), R5(j,j',i'), and R5(k,k',i')
        
        % R1
        invalidTERs{1}.regionType = 1; 
              
        % R2(j,k)
        invalidTERs{2}.regionType = 2;
        invalidTERs{2}.lineIdxs = [lineIdxs(2),lineIdxs(3)];
        
        % R3(j, i', k') 
        invalidTERs{3}.regionType = 3;
        invalidTERs{3}.lineIdxs = [lineIdxs(2),lineIdxs(1),lineIdxs(3)];
        
        % R3(k, i', j')
        invalidTERs{4}.regionType = 3;
        invalidTERs{4}.lineIdxs = [lineIdxs(3),lineIdxs(1),lineIdxs(2)];
        
        % R4(i', j')
        invalidTERs{5}.regionType = 4;
        invalidTERs{5}.lineIdxs = [lineIdxs(1),lineIdxs(2)];
        
        % R5(i,i',j')
        invalidTERs{6}.regionType = 5;
        invalidTERs{6}.lineIdxs = [lineIdxs(1),lineIdxs(1),lineIdxs(2)];
        
        % R5(j,j',i')
        invalidTERs{7}.regionType = 5;
        invalidTERs{7}.lineIdxs = [lineIdxs(2),lineIdxs(2),lineIdxs(1)];
        
        % R5(k,k',i')
        invalidTERs{8}.regionType = 5;
        invalidTERs{8}.lineIdxs = [lineIdxs(3),lineIdxs(3),lineIdxs(1)];
    
    case 2
        % The invalid regions are: 
        % R2(i,k), R2(j,k), R3(i,j',k'), R4(i',k'), R4(j',k'), 
        % R5(j,j',k'), R5(k,k',i'), and R5(k,k',j')
        
        
        % R2(i,k) 
        invalidTERs{1}.regionType = 2;
        invalidTERs{1}.lineIdxs = [lineIdxs(1),lineIdxs(3)];
        
        % R2(j,k)
        invalidTERs{2}.regionType = 2;
        invalidTERs{2}.lineIdxs = [lineIdxs(2),lineIdxs(3)];
        
        % R3(i,j',k')
        invalidTERs{3}.regionType = 3;
        invalidTERs{3}.lineIdxs = [lineIdxs(1),lineIdxs(2),lineIdxs(3)];
        
        % R4(i',k')
        invalidTERs{4}.regionType = 4;
        invalidTERs{4}.lineIdxs = [lineIdxs(1),lineIdxs(3)];
        
        % R4(j',k') 
        invalidTERs{5}.regionType = 4;
        invalidTERs{5}.lineIdxs = [lineIdxs(2),lineIdxs(3)];
        
        % R5(j,j',k')
        invalidTERs{6}.regionType = 5;
        invalidTERs{6}.lineIdxs = [lineIdxs(2),lineIdxs(2),lineIdxs(3)];
        
        % R5(k,k',i')
        invalidTERs{7}.regionType = 5;
        invalidTERs{7}.lineIdxs = [lineIdxs(3),lineIdxs(3),lineIdxs(1)];
        
        % R5(k,k',j')        
        invalidTERs{8}.regionType = 5;
        invalidTERs{8}.lineIdxs = [lineIdxs(3),lineIdxs(3),lineIdxs(2)];
        
    case 3
        % The invalid regions are: 
        % R2(i,j), R2(i,k), R3(k,i',j'), R4(i',j'), R4(i',k'),
        % R5(i,i',j'), R5(i,i',k'), and R5(j,j',i').     
        
        % R2(i,j) 
        invalidTERs{1}.regionType = 2;
        invalidTERs{1}.lineIdxs = [lineIdxs(1),lineIdxs(2)];
        
        % R2(i,k)
        invalidTERs{2}.regionType = 2;
        invalidTERs{2}.lineIdxs = [lineIdxs(1),lineIdxs(3)];
        
        % R3(k,i',j')
        invalidTERs{3}.regionType = 3;
        invalidTERs{3}.lineIdxs = [lineIdxs(3),lineIdxs(1),lineIdxs(2)];
        
        % R4(i',j')
        invalidTERs{4}.regionType = 4;
        invalidTERs{4}.lineIdxs = [lineIdxs(1),lineIdxs(2)];
        
        % R4(i',k') 
        invalidTERs{5}.regionType = 4;
        invalidTERs{5}.lineIdxs = [lineIdxs(1),lineIdxs(3)];
        
        % R5(i,i',j')
        invalidTERs{6}.regionType = 5;
        invalidTERs{6}.lineIdxs = [lineIdxs(1),lineIdxs(1),lineIdxs(2)];
        
        % R5(i,i',k')
        invalidTERs{7}.regionType = 5;
        invalidTERs{7}.lineIdxs = [lineIdxs(1),lineIdxs(1),lineIdxs(3)];
        
        % R5(j,j',i')        
        invalidTERs{8}.regionType = 5;
        invalidTERs{8}.lineIdxs = [lineIdxs(2),lineIdxs(2),lineIdxs(1)];
        
    case 4
        % The invalid regions are: 
        % R1, R2(i,j), R3(i, j', k'), R3(j, i', k'), R4(j', k'),
        % R5(i,i',k'), R5(j,j',k'), and R5(k,k',j')
        
        % R1
        invalidTERs{1}.regionType = 1; 
              
        % R2(i,j)
        invalidTERs{2}.regionType = 2;
        invalidTERs{2}.lineIdxs = [lineIdxs(1),lineIdxs(2)];
        
        % R3(i, j', k') 
        invalidTERs{3}.regionType = 3;
        invalidTERs{3}.lineIdxs = [lineIdxs(1),lineIdxs(2),lineIdxs(3)];
        
        % R3(j, i', k')
        invalidTERs{4}.regionType = 3;
        invalidTERs{4}.lineIdxs = [lineIdxs(2),lineIdxs(1),lineIdxs(3)];
        
        % R4(j', k')
        invalidTERs{5}.regionType = 4;
        invalidTERs{5}.lineIdxs = [lineIdxs(2),lineIdxs(3)];
        
        % R5(i,i',k')
        invalidTERs{6}.regionType = 5;
        invalidTERs{6}.lineIdxs = [lineIdxs(1),lineIdxs(1),lineIdxs(3)];
        
        % R5(j,j',k')
        invalidTERs{7}.regionType = 5;
        invalidTERs{7}.lineIdxs = [lineIdxs(2),lineIdxs(2),lineIdxs(3)];
        
        % R5(k,k',j')
        invalidTERs{8}.regionType = 5;
        invalidTERs{8}.lineIdxs = [lineIdxs(3),lineIdxs(3),lineIdxs(2)];
           
    otherwise
end