function varargout = orderImages(varargin)
% ORDERIMAGES MATLAB code for orderImages.fig
%      ORDERIMAGES, by itself, creates a new ORDERIMAGES or raises the existing
%      singleton*.
%
%      H = ORDERIMAGES returns the handle to a new ORDERIMAGES or the handle to
%      the existing singleton*.
%
%      ORDERIMAGES('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in ORDERIMAGES.M with the given input arguments.
%
%      ORDERIMAGES('Property','Value',...) creates a new ORDERIMAGES or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before orderImages_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to orderImages_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help orderImages

% Last Modified by GUIDE v2.5 23-Feb-2016 11:56:41

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @orderImages_OpeningFcn, ...
                   'gui_OutputFcn',  @orderImages_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before orderImages is made visible.
function orderImages_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to orderImages (see VARARGIN)

% If the path is given
if nargin == 4
    handles.guiInfo.imagesPath = varargin{1};
else
    % Get the directory of the images.
    handles.guiInfo.imagesPath = uigetdir();
end

% Get the list of images in the path.
imageNames = getImagesInDir(handles.guiInfo.imagesPath);

% Update the list box with the images.
set(handles.imagesList,'String',imageNames);

% Choose default command line output for orderImages
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes orderImages wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = orderImages_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
handles.guiInfo.orderedImList = get(handles.imagesList,'String');
varargout{1} = handles.guiInfo;
% The figure can be deleted now
delete(handles.figure1);



% --- Executes on selection change in imagesList.
function imagesList_Callback(hObject, eventdata, handles)
% hObject    handle to imagesList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns imagesList contents as cell array
%        contents{get(hObject,'Value')} returns selected item from imagesList


% --- Executes during object creation, after setting all properties.
function imagesList_CreateFcn(hObject, eventdata, handles)
% hObject    handle to imagesList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in upBtn.
function upBtn_Callback(hObject, eventdata, handles)
% hObject    handle to upBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

moveSelectionUp(handles);


% --- Executes on button press in downBtn.
function downBtn_Callback(hObject, eventdata, handles)
% hObject    handle to downBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

moveSelectionDown(handles);


% --- Executes on button press in closeBtn.
function closeBtn_Callback(hObject, eventdata, handles)
% hObject    handle to closeBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(gcf);
breakpoint = 1;


% --- This function moves the selection up in the list (unless it is
% already at the top of the list).
function moveSelectionUp(handles)

% Get the index of the currently selected file name.  
selectedIdx = get(handles.imagesList, 'Value');

% Only do this if we are not at the top.
if selectedIdx > 1
    listItems = get(handles.imagesList,'String');
    
    temp = listItems(selectedIdx);
    listItems(selectedIdx) = listItems(selectedIdx - 1);
    listItems(selectedIdx - 1) = temp;

    % Update the list
    set(handles.imagesList,'Value',selectedIdx - 1);
    set(handles.imagesList,'String',listItems);
end


% --- This function moves the selection down in the list (unless it is
% already at the top of the list).
function moveSelectionDown(handles)

% Get the index of the currently selected file name.  
selectedIdx = get(handles.imagesList, 'Value');
listItems = get(handles.imagesList,'String');
% Only do this if we are not at the top.
if selectedIdx < length(listItems);
    
    temp = listItems(selectedIdx);
    listItems(selectedIdx) = listItems(selectedIdx + 1);
    listItems(selectedIdx + 1) = temp;

    % Update the list
    set(handles.imagesList,'Value',selectedIdx + 1);
    set(handles.imagesList,'String',listItems);
end


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isequal(get(hObject, 'waitstatus'), 'waiting')
% The GUI is still in UIWAIT, us UIRESUME
uiresume(hObject);
else
% The GUI is no longer waiting, just close it
delete(hObject);
end

