function varargout = selectInitCorr(varargin)
% SELECTINITCORR MATLAB code for selectInitCorr.fig
%      SELECTINITCORR, by itself, creates a new SELECTINITCORR or raises the existing
%      singleton*.
%
%      H = SELECTINITCORR returns the handle to a new SELECTINITCORR or the handle to
%      the existing singleton*.
%
%      SELECTINITCORR('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SELECTINITCORR.M with the given input arguments.
%
%      SELECTINITCORR('Property','Value',...) creates a new SELECTINITCORR or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before selectInitCorr_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to selectInitCorr_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help selectInitCorr

% Last Modified by GUIDE v2.5 24-Feb-2016 18:31:28

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @selectInitCorr_OpeningFcn, ...
                   'gui_OutputFcn',  @selectInitCorr_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before selectInitCorr is made visible.
function selectInitCorr_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to selectInitCorr (see VARARGIN)

% Get the images.
if nargin == 4
    handles.images = varargin{1};
end

% Populate the listbox with the image names (in order).
imageNames = cell(1,size(handles.images,2));
numImages = size(handles.images,2);
for imIdx = 1:numImages
    imageNames{imIdx} = handles.images{imIdx}.imageName;
end
set(handles.imagesListBox,'String',imageNames);

% Create a handles value, p, which corresponds to points selected.
handles.p = zeros(2,numImages);

% Load the currently selected image onto the axes.
loadImageOntoAxes(handles);

% Choose default command line output for selectInitCorr
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes selectInitCorr wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = selectInitCorr_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

varargout{1} = handles.p;
% The figure can be deleted now
delete(handles.figure1);


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isequal(get(hObject, 'waitstatus'), 'waiting')
% The GUI is still in UIWAIT, us UIRESUME
uiresume(hObject);
else
% The GUI is no longer waiting, just close it
delete(hObject);
end


% --- Executes on button press in zoomInBtn.
function zoomInBtn_Callback(hObject, eventdata, handles)
% hObject    handle to zoomInBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Update the instructions on the top.
set(handles.instructionTxt,'String',['Adjust the zoom around the point '...
    'of interest and press Return.']);

% Allow the user to adjust the zoom around the area of interest, wait for 
% the Return key to be hit.
zoom on;
pause;
zoom off;
shg;

% Remove the instructions.
set(handles.instructionTxt,'String','');

% --- Executes on button press in zoomOutBtn.
function zoomOutBtn_Callback(hObject, eventdata, handles)
% hObject    handle to zoomOutBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Zoom out on the image.
zoom out;



% --- Executes on button press in selectBtn.
function selectBtn_Callback(hObject, eventdata, handles)
% hObject    handle to selectBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Update the instructions on the top.
set(handles.instructionTxt,'String',['Select the point of interest, '...
    'then press Return.']);


% Switch to a data selection mode and wait for the user to hit Return.
dcm_obj = datacursormode(handles.figure1);
set(dcm_obj,'DisplayStyle','datatip',...
    'SnapToDataVertex','off','Enable','on')
pause 

% Get the user input.
dcminfo = getCursorInfo(dcm_obj);

% Remove the instructions.
set(handles.instructionTxt,'String','');

% Save the selection to the handles.

% Get the index of the image selected.
selectedImIdx = get(handles.imagesListBox,'value');

% Only save the selection if the user did selected a point.
if ~isempty(dcminfo)
    handles.p(:,selectedImIdx) = dcminfo.Position';
end


% Update handles structure
guidata(hObject, handles);

% Move the figure to the front again.
figure(handles.figure1);




% --- Executes on selection change in imagesListBox.
function imagesListBox_Callback(hObject, eventdata, handles)
% hObject    handle to imagesListBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns imagesListBox contents as cell array
%        contents{get(hObject,'Value')} returns selected item from imagesListBox

% Update the image shown.
loadImageOntoAxes(handles);


% --- Executes during object creation, after setting all properties.
function imagesListBox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to imagesListBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function loadImageOntoAxes(handles)
% This function plots the image selected in the listbox and its features 
% onto the axes.

% Get the index of the image selected.
selectedImIdx = get(handles.imagesListBox,'value');

% Select and clear the axes.
axes(handles.imageAxes);
cla;

% Show the image on the axes.
imshow(handles.images{selectedImIdx}.image, 'Parent', handles.imageAxes);
hold on;

% If feature points are given, plot them.
if isfield(handles.images{selectedImIdx},'f')
    % Plot the feature points on the axes.
    plot(handles.images{selectedImIdx}.f(1,:),...
        handles.images{selectedImIdx}.f(2,:),'gs');
end

% Zoom out in case the user previously zoomed in.
zoom out;

% --- Executes on button press in doneBtn.
function doneBtn_Callback(hObject, eventdata, handles)
% hObject    handle to doneBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(gcf);
