function [x,y] = PolySetFun(x1,y1,x2,y2,op)
% [x,y] = PolySetFun(x1,y1,x2,y2,op)
%
% Author: Mor Dar
% Last Change: April 4, 2016
%
% This function runs polybool on a set of cells using the operation given
% and returns the NaN separated result.

% Work with cells only, in order to do that convert both inputs to cells if
% they are not already.
if iscell(x2)
    [x2,y2] = polyjoin(x2,y2);
end

% If the first input is empty, use the first element in the second input.
if isempty(x1)
    x1 = x2; y1 = y2;
else
    % If it is not empty, ensure that it is a cell.
    if iscell(x1)
        [x1,y1] = polyjoin(x1,y1);
    end
end

try
    % Try running polybool.
    [x,y] = polybool(op,x1,y1,x2,y2);
catch
    % If polybool doesn't work, use a workaround to get it to work.
    x1(~isnan(x1)) = round(x1(~isnan(x1))/100)/100.00;
    x2(~isnan(x2)) = round(x2(~isnan(x2))/100)/100.00;
    y1(~isnan(y1)) = round(y1(~isnan(y1))/100)/100.00;
    y2(~isnan(y2)) = round(y2(~isnan(y2))/100)/100.00;
    [x,y] = polybool(op,x1,y1,x2,y2);
end