function images = readImages(imageInfo)
% images = readImages(imageInfo)
%
% Author: Mor Dar
% Last Change: April 4, 2016
%
% This function recieves image information (directory path and file names
% in temporal order of capture) and reads in the actual images into the
% image array while preserving the order.

% The number of files
nfiles = size(imageInfo.orderedImList,1);

% Initialize variables.
images = cell(1,nfiles);

% For each image
for i = 1:nfiles
    disp(['Loading image ', num2str(imageInfo.orderedImList{i}),'.']);
    % Load the images and extract them
    images{i}.image = imread([imageInfo.imagesPath,'\',imageInfo.orderedImList{i}]);
    images{i}.imagePath = [imageInfo.imagesPath,'\',imageInfo.orderedImList{i}];
    images{i}.imageName = imageInfo.orderedImList{i};
end