function [cwX,cwY] = sortPointsCW(x,y)
% [cwX,cwY] = sortPointsCW(x,y)
%
% Author: Mor Dar
% Last Change: April 4, 2016
%
% This function sorts a random order of points in clockwise fashion.
% Note we assume convex shapes, very concave ones may cause problems.

% Find the centroids
cx = mean(x);
cy = mean(y);

% Find the angles.
a = atan2(y-cy,x-cx);

% Find the correct sorted order.
[~,order] = sort(a,'descend');

% Order the points according to the sorting.
cwX = x(order);
cwY = y(order);

