function images = loadAndOrderImFromDir()
% images = loadAndOrderImFromDir()
%
% Author: Mor Dar
% Last Change: April 4, 2016
%
% This function asks the user for a directory containing the image set.
% Then, it allows the user to manually order the images in time. Finally,
% it reads the images in to a structure and formats it for use with
% runTERs.  
%
% Note that finding the temporal order can be done using photosequencing,
% but as this is not the focus of our work we only offer manual
% selection of temporal ordering.  
%
% Output        Details
%
% images    This function outputs the image data as a 1xN cell array
%           containing the following:
%           
%               images{idx}.image       The actual image (ie. output of imread).
%               images{idx}.imageName   The name of the image (used only
%                                       for displaying purposes at the end).

% Getting the path to the images is handled by the orderImages GUI.  This
% GUI prompt the user for a directory, reads the names of the image files
% in the directory and allows the user to order the images.
orderedImList = orderImages();

% Actually read and save the images to a structure. 
images = readImages(orderedImList);