function [D,Z,E] = LRR_D(X,A,lambda,rho)
[d_x,n] = size(A);
[d_x,nt] = size(X);
Z = zeros(n,nt);
for j = 1:nt
    DifAZj = A - repmat(X(:,j),[1,n]);
    sqdis = sum(DifAZj.^2);
    [~,mini] = min(sqdis);
    Z(mini,j) = 1;
end
%Z = zeros(n,nt);
D = A*Z;
E = X-D;
Z1 = X/norm(X,'fro');
mu1 = d_x*n/4/norm(X(:),1);
lambda = 1 / sqrt(min(d_x,n));
s = svd(A);
nunormA = sum(s);
%lambda = lambda / nunormA;
for iter = 1:20
    
    TempE =  X - D + Z1 / mu1; 
    for cn=1:nt
        Ecol = TempE(:,cn);
        if norm(Ecol) < lambda / mu1
            Ecol(:) = 0;
        end
        E(:,cn) = Ecol;
    end
    
    tau_Z1= vrho(A'*A) + 0.000001;
    tau_Z = norm(A'*A,'fro').^2;
    beta_Z = mu1 * tau_Z;
    FZk = A'*( -Z1 + mu1 * ( D - (X-E) ) );
    [U,S,V] = svd(Z - FZk / beta_Z);
    s = diag(S);
    s = max(s-1/beta_Z,0);
    Z = U(:,1:length(s))*diag(s)*V(:,1:length(s))';
    D = A*Z;
    E = So( lambda / mu1 , X - D + Z1 / mu1 );
    Z1 = Z1 + mu1*(X-D-E);
    Xdif_ratio = norm(X-D-E,'fro')/norm(X,'fro');
    if  Xdif_ratio <=1e-8
        break;
    end
    mu1 = min(rho*mu1,1e6);
end
end
function r = So(tau, X)
    % shrinkage operator
    r = sign(X) .* max(abs(X) - tau, 0);
end

function r = Do(tau, X)
    % shrinkage operator for singular values
    [U, S, V] = svd(X, 'econ');
    r = U*So(tau, S)*V';
end