function [eigenfaces,meanFace] = calculate_eigen_faces(varargin)

eigenDim = 20;

folderName = './data/CroppedYale';
D = dir(folderName);
D(1:2) = [];
Im = imread([folderName,'/',D(1).name]);
[m,n] = size(Im);
downSizeM = m; downSizeN = n;
T = zeros(length(D),downSizeM*downSizeN);
for i = 1:length(D)
    Im = imread([folderName,'/',D(i).name]);
    im = Im;
    T(i,:) = double(reshape(im',[],1)');
end
T = T';
meanFace = mean(T,2);
T = T-meanFace(:,ones(1,size(T,2)));
[U,D] = eig(T'*T);
d = diag(D);
V = T*U;
[~,I] = sort(d,'descend');
eigenfaces = V(:,I(1:eigenDim))*diag((d(I(1:eigenDim)).^(-1/2)));
eigenfaces = eigenfaces';