function T = tls(xdata,ydata) 
[vn,sn] = size(xdata);
m = sn; %number of x,y data pairs 
A = xdata'; 
B = ydata'; 
n = vn; % n is the width of A (A is m by n) 
C = [A B]; % C is A augmented with B. 
[U,S,V] = svd(C,0); % find the SVD of C. 
VAB = V(1:n,1+n:end); % Take the block of V consisting of the first n rows and the n+1 to last column 
VBB = V(1+n:end,1+n:end); % Take the bottom-right block of V. 
T = -VAB/VBB; 
T = T';
end