function [ X, mres, nitr] = f_tri_L2_FDM_single(a1, a2, b1, b2, c, d, X0, aeps)


    mres0 = Inf;
    mres = 1e10;
    flag = true;

    tol = 1e-8;  
    tol = 1e-4;
    maxitr = 100; 
    nitr = 0;
    X = X0;
    
    while abs(mres0-mres)> tol  && nitr<maxitr
        nitr = nitr+1;
        % find the active constraints

        res = sqrt( (a1*X+b1).^2 + (a2*X+b2).^2 ) ./ (c*X+d);
        mres0 = mres;
        mres = max(res);
        if mres>mres0
            flag = false;
            break;
        end
        Active = find(mres-res<=mres*aeps)';

        [grad] = f_grad_L2(a1(Active,:), a2(Active,:), b1(Active), b2(Active), c(Active,:), d(Active), X);

        [ dir, ~ ] = f_meb( -grad);  r = norm(dir);
        
        if r<tol % none valid descent direction
            break;
        end
        dir = dir/norm(dir);
        
        [lb, ub] = f_getbound(c,d,X,dir);
        [ alpha ] = f_stepsize_L2( a1, a2, b1, b2, c, d, X, dir, Active, mres, lb, ub, 1 );

        if alpha < tol
            break;
        end
        % update X
        X0 = X;
        X = X + alpha * dir;

    end % while

    if ~flag
        X = X0;
        mres = mres0;
    end
end


