import numpy as np
import matplotlib.pyplot as plt
import matplotlib.patches as patches

# read boxes
ex1_label = np.loadtxt("./frame_ev_pair_01616.txt", usecols=(1, 2, 3, 4))
ex2_label = np.loadtxt("./frame_ev_pair_01722.txt", usecols=(1, 2, 3, 4))

# real images
ex1_data = np.load("./frame_ev_pair_01616.npz")
ex2_data = np.load("./frame_ev_pair_01722.npz")

fig = plt.figure(figsize=(12, 6))

ax = plt.subplot(1, 2, 1)
plt.imshow(ex1_data["img"], cmap="gray")
plt.axis("off")
plt.title("Example 1")
for box in ex1_label:
    box = box.astype(int)
    box[box < 0] = 0
    rect = patches.Rectangle(
        (box[0], box[1]), box[2]-box[0], box[3]-box[1],
        linewidth=3, edgecolor='r', facecolor='none')
    ax.add_patch(rect)

ax = plt.subplot(1, 2, 2)
plt.imshow(ex2_data["img"], cmap="gray")
plt.axis("off")
plt.title("Example 2")
for box in ex2_label:
    box = box.astype(int)
    box[box < 0] = 0
    rect = patches.Rectangle(
        (box[0], box[1]), box[2]-box[0], box[3]-box[1],
        linewidth=3, edgecolor='r', facecolor='none')
    ax.add_patch(rect)

plt.tight_layout()

plt.show()
