import pickle
import numpy as np
from PIL import Image
from .hist import draw_style
from .test import add_text

def load_style_list(path='datasets/icon/color_image_scale.pkl'):
    with open(path, 'rb') as f:
        scale = pickle.load(f)
    style_list = []
    for group, styles in scale.items():
        group = group.replace(' ', '_')
        for style, pos, cmb in styles:
            style = style.replace(' ', '_')
            name = f'{group}/{style}'
            style_list.append((name, (pos, cmb)))
    style_list.sort(key=lambda t: t[0])
    return style_list

def load_style_lists(path='datasets/icon/color_image_scale.pkl'):
    style_list = load_style_list(path)

    style_to_pos = {}
    style_to_cmb = {}

    style_name_list = []
    style_pos_list = []
    style_cmb_list = []

    for name, (pos, cmb) in style_list:
        style_name_list.append(name)
        style_pos_list.append(pos)
        style_cmb_list.append(cmb)
        style_to_pos[name] = pos
        style_to_cmb[name] = cmb
    
    return dict(name_list=style_name_list,
                pos_list=style_pos_list, cmb_list=style_cmb_list,
                name_to_pos=style_to_pos, name_to_cmb=style_to_cmb)

def get_style_img(cmb, text=''):
    img = Image.new('RGB', (128,)*2, (255,)*3)
    img.paste(draw_style(cmb).resize((128, 128-40)), (0, 40))
    if text:
        img = add_text(img, text)
    return img
