import tempfile
import neptune.new as neptune
import os
import mmcv

def load_results(run_id, model_name):
    run = neptune.init(
        project=os.environ["NEPTUNE_PROJECT"], run=run_id, mode="read-only"
    )
    with tempfile.TemporaryDirectory() as tmpdirname:
        run[f"results/{model_name}"].download(tmpdirname)
        results = mmcv.load(os.path.join(tmpdirname, f"{model_name}.pkl"))
    run.stop()
    return results
