# AuxMix
This is PyTorch implementation of AuxMix: Semi-Supervised Learning with Unconstrained Unlabeled Data.


![image](algopic.png)

## Requirements
- python 3.7
- torch 1.6
- torchvision 0.7.0
- tensorboard
- numpy
- tqdm
- torchsummary

## Usage
Train the model by 4000 labeled data of CIFAR-10 dataset and TinyImagenet as aux dataset:

```
python train_prototype.py --dataset cifar10 --num-labeled 4000 --arch resnet --batch-size 64 --lr 0.03
--lr-rot 0.1 --scheduler-type cosine --auto-thresh --alpha-thresh -1 --expand-labels --seed 5 --use-ema 
--out results/cifar10-4k-auxtiny-100k
```

## Results

### CIFAR10-Animals (400 images / class) as labeled and others are unabeled
| Method | Error Rate |
|:---:|:---:|
| Supervised          | 22.47 |
| Temporal Ensembling | 27.08 |
| Mean Teacher        | 26.81 |
| VAT                 | 26.19 | 
| Pseudo-Label        | 25.94 |
| SWA                 | 24.10 |
| UASD                | 22.47 |
| RealMix             | 17.62 |
| AuxMix (Ours)       | 14.12 |

### CIFAR10-4k Labeled, Others Unlabeled
| Method | Tiny-Imagenet | CUB | Noise |
|:---:|:---:|:---:|:---:|
| Supervised          | 59.91 | 59.91 | 59.91 | 
| Pseudo-Label        | 63.04 | 61.80 | 64.89 |
| MPL                 | 49.18 | 68.86 | 52.44 |
| FixMatch            | 58.48 | 49.23 | 65.88 |
| AuxMix (Ours)       | 68.38 | 73.95 | 69.34 |

### Ablations
| Method | Accuracy |
|:---:|:---:|
| Supervised                            | 77.53 | 
| AuxMix                                | 85.88 |
| AuxMix without EntMax                 | 84.13 |
| AuxMix without Similarity Masking     | 83.92 |


## References
- [Unofficial PyTorch implementation of FixMatch](https://github.com/kekmodel/FixMatch-pytorch)
- [PyTorch image models](https://github.com/rwightman/pytorch-image-models)
