import os
import numpy as np
from PIL import Image
from numpy.random import rand

n_samples = 50000
dir_path = "/mnt/my_files/aux-learning/data/noise-{}".format(n_samples)

# generate n fake samples with class labels
def generate_fake_samples(n_samples):
	# generate uniform random numbers in [0,1]
	X = rand(32 * 32 * 3 * n_samples)
	# reshape into a batch of color images
	X = X.reshape((n_samples, 32, 32, 3))

	return X

if __name__ =='__main__':
    if not os.path.exists(dir_path):
        os.mkdir(dir_path)

    imgs = generate_fake_samples(n_samples)
    for num, i in enumerate(imgs):
        img = Image.fromarray((i * 255).astype(np.uint8))
        img.save(os.path.join(dir_path, 'noise_img_{:5d}.jpg'.format(num)))