#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import print_function
import torch.nn as nn

# Convenience dicts
imsize_dict = {
    'I32': 32,
    'I32_hdf5': 32,
    'I64': 64,
    'I64_hdf5': 64,
    'I128': 128,
    'I128_hdf5': 128,
    'I256': 256,
    'I256_hdf5': 256,
    'C10': 32,
    'C100': 32
}

nclass_dict = {
    'I32': 1000,
    'I32_hdf5': 1000,
    'I64': 1000,
    'I64_hdf5': 1000,
    'I128': 1000,
    'I128_hdf5': 1000,
    'I256': 1000,
    'I256_hdf5': 1000,
    'C10': 10,
    'C100': 100
}

activation_dict = {
    'inplace_relu': nn.ReLU(inplace=True),
    'relu': nn.ReLU(inplace=False),
    'ir': nn.ReLU(inplace=True)
}
