#include <cosy/affine.h>
#include <catch2/catch_test_macros.hpp>
#include <xtensor/xmath.hpp>
#include <xtensor/xadapt.hpp>

TEST_CASE("NamedAxes")
{
  {
    cosy::NamedAxes<2> axes1({{"north", "south"}, {"east", "west"}});
    cosy::NamedAxes<2> axes2({{"east", "west"}, {"south", "north"}});
    cosy::NamedAxesTransformation<double, 2> axes1_to_axes2(axes1, axes2);

    REQUIRE(xt::abs(xt::mean(xti::vec2d({0, -1}) - axes1_to_axes2.transform(xti::vec2d({1, 0}))))() < 1e-6);
    REQUIRE(xt::abs(xt::mean(xti::vec2d({0, 1}) - axes1_to_axes2.transform(xti::vec2d({-1, 0}))))() < 1e-6);
    REQUIRE(xt::abs(xt::mean(xti::vec2d({1, 0}) - axes1_to_axes2.transform(xti::vec2d({0, 1}))))() < 1e-6);
    REQUIRE(xt::abs(xt::mean(xti::vec2d({-1, 0}) - axes1_to_axes2.transform(xti::vec2d({0, -1}))))() < 1e-6);
  }

  {
    cosy::NamedAxes<2> axes1({{"east", "west"}, {"north", "south"}});
    cosy::NamedAxes<2> axes2({{"south", "north"}, {"east", "west"}});
    cosy::NamedAxesTransformation<double, 2> axes1_to_axes2(axes1, axes2);

    REQUIRE(xt::abs(xt::mean(xti::vec2d({0, 1}) - axes1_to_axes2.transform(xti::vec2d({1, 0}))))() < 1e-6);
    REQUIRE(xt::abs(xt::mean(xti::vec2d({0, -1}) - axes1_to_axes2.transform(xti::vec2d({-1, 0}))))() < 1e-6);
    REQUIRE(xt::abs(xt::mean(xti::vec2d({-1, 0}) - axes1_to_axes2.transform(xti::vec2d({0, 1}))))() < 1e-6);
    REQUIRE(xt::abs(xt::mean(xti::vec2d({1, 0}) - axes1_to_axes2.transform(xti::vec2d({0, -1}))))() < 1e-6);
  }
}
