#pragma once

#include <exception>

namespace georegdata::ground {

class LoadException : public std::exception
{
public:
  LoadException(std::string message)
    : m_message(message)
  {
  }

  virtual const char* what() const throw ()
  {
    return m_message.c_str();
  }

private:
  std::string m_message;
};

} // end of ns georegdata::ground
