import numpy as np
import cv2, cosy, math

def frame_visualize(self, points_alpha=1.0, bevpixels_to_aerialpixels=None, radius=None, color="height"):
    aerial_image = np.copy(self.aerial_frame.image)

    if self.ground_frame.points_ego.shape[0] > 0:
        if isinstance(color, str) and color == "height":
            height = self.ground_frame.points_ego[:, 2]
            min_height = np.amin(height)
            max_height = np.amax(height)
            color = (height - min_height) / (max_height - min_height + 1e-7)
            color = cv2.applyColorMap(np.asarray([color * 255.0]).astype("uint8"), cv2.COLORMAP_JET)[0, :, ::-1]
        color = np.asarray(color)

        if bevpixels_to_aerialpixels is None:
            bevpixels_to_aerialpixels = self.bevpixels_to_aerialpixels

        aerial_pixels = bevpixels_to_aerialpixels(self.ground_frame.bev_pixels.astype("float32"))
        aerial_pixels = aerial_pixels + np.asarray(self.aerial_frame.image.shape[:2])[np.newaxis, :] / 2
        mask = np.all(np.logical_and(0 <= aerial_pixels, aerial_pixels < np.asarray(self.aerial_frame.image.shape[:2])[np.newaxis, :]), axis=-1)
        aerial_pixels = aerial_pixels[mask]
        if len(color.shape) >= 2:
            color = color[mask]

        if not radius is None:
            xxc, yyc = np.mgrid[:2 * int(radius), :2 * int(radius)]
            circle = (xxc - radius) ** 2 + (yyc - radius) ** 2 < radius ** 2
            xxc = xxc[circle] - radius
            yyc = yyc[circle] - radius

            pixels_per_circle = xxc.shape[0]
            points_num = aerial_pixels.shape[0]

            aerial_pixels = np.repeat(aerial_pixels, pixels_per_circle, axis=0) + np.tile(np.stack([xxc, yyc], axis=1), [points_num, 1])

            mask = np.all(np.logical_and(0 <= aerial_pixels, aerial_pixels < np.asarray(aerial_image.shape[:2])[np.newaxis, :]), axis=-1)
            aerial_pixels = aerial_pixels[mask, :]
        aerial_pixels = aerial_pixels.astype("int32")
        aerial_image[aerial_pixels[:, 0], aerial_pixels[:, 1]] = np.clip(points_alpha * color + (1.0 - points_alpha) * aerial_image[aerial_pixels[:, 0], aerial_pixels[:, 1]], 0.0, 255.0).astype("uint8")

    return aerial_image
from georegdata.backend import Frame
setattr(Frame, "visualize", frame_visualize)
