import numpy as np
import cv2, math

def camera_visualize(self, log=True, points_alpha=0.5, radius=None):
    pixels = self.pixels[self.points_mask, :].astype("uint32")
    depths = self.points_depth[self.points_mask]
    image = np.copy(self.image)
    if depths.size > 0:
        if log:
            depths = np.log(depths)
        min_depth = np.amin(depths)
        max_depth = np.amax(depths)
        if max_depth > min_depth:
            depths = (depths - min_depth) / (max_depth - min_depth)
        else:
            depths = depths * 0 + 0.5

        # Create coordinates of single circle
        if radius is None:
            radius = max(1, int(math.sqrt(float(image.shape[0] * image.shape[1])) * 0.003))
        radius = int(radius)
        xxc, yyc = np.mgrid[:2 * radius, :2 * radius]
        circle = (xxc - radius) ** 2 + (yyc - radius) ** 2 < radius ** 2
        xxc = xxc[circle] - radius
        yyc = yyc[circle] - radius

        pixels_per_circle = xxc.shape[0]
        points_num = pixels.shape[0]

        # Add circle coordinates to every point
        color = cv2.applyColorMap(np.asarray([depths * 255.0]).astype("uint8"), cv2.COLORMAP_JET)[0, :, ::-1]
        color = np.repeat(color, pixels_per_circle, axis=0)
        pixels = np.repeat(pixels, pixels_per_circle, axis=0) + np.tile(np.stack([xxc, yyc], axis=1), [points_num, 1])

        # Filter out of bounds pixels
        mask = np.all(np.logical_and(0 <= pixels, pixels < np.asarray(image.shape[:2])[np.newaxis, :]), axis=-1)
        color = color[mask, :]
        pixels = pixels[mask, :]

        # Apply color
        image[pixels[:, 0], pixels[:, 1]] = np.clip(points_alpha * color + (1.0 - points_alpha) * image[pixels[:, 0], pixels[:, 1]], 0.0, 255.0).astype("uint8")
    return image
from georegdata.backend.ground import Camera
setattr(Camera, "visualize", camera_visualize)

def frame_id_get_params(self):
    return {
        "dataset_name": self.dataset_name,
        "location": self.location,
        "scene_id": self.scene_id,
        "index_in_scene": self.index_in_scene,
        "timestamp": self.timestamp,
        "crs": self.crs,
        "ego_to_world": self.ego_to_world,
        "world_to_crs": self.world_to_crs,
        "epsg4326_to_crs": self.epsg4326_to_crs,
        "cameras": self.cameras,
        "lidars": self.lidars,
        "imu": self.imu,
    }
from georegdata.backend.ground import FrameId
setattr(FrameId, "get_params", frame_id_get_params)
