import itertools, random, tinyobserver
import tinypl as pl

def stream(frame_ids, epochs, batch_size, process, load_threads=4, load_queue=4, process_threads=4, process_queue=4, track=None, track_event=None):
    if track_event is None:
        track_event = tinyobserver.clock.Thread(interval=2.0)

    stream = itertools.repeat(frame_ids, epochs)
    stream = pl.map(lambda list: random.sample(list, len(list)), stream)
    stream, epoch_end_marker = pl.marker.after_each(stream)
    stream, epoch_order = pl.order.save(stream)
    stream = pl.flatten(stream)
    stream = pl.sync(stream) # Concurrent processing starts after this point

    # Load frame
    stream = pl.map(lambda frame_id: frame_id.load(), stream)
    stream = pl.queued(stream, workers=load_threads, maxsize=load_queue)
    if not track is None:
        track_event.subscribe(lambda stream=stream: track("loaded_files", stream.getFill()))

    # Preprocess frame
    stream = pl.map(process, stream)
    stream = pl.queued(stream, workers=process_threads, maxsize=process_queue)
    if not track is None:
        track_event.subscribe(lambda stream=stream: track("ready_frames", stream.getFill()))

    stream = pl.order.load(stream, epoch_order)

    for _ in range(epochs):
        yield pl.partition(batch_size, pl.marker.until(stream))

image_extensions = ["jpg", "jpeg", "png", "tif", "tiff"]

def is_image_file(file):
    return any([file.endswith("." + ext) for ext in image_extensions])
