import numpy as np

class ImageType:
    def __init__(self, type):
        if type == "color":
            self.border_value = 0
            self.interpolation_order = 1
        elif type == "class":
            self.border_value = -1
            self.interpolation_order = 0
        elif type == "mask":
            self.border_value = False
            self.interpolation_order = 0
        else:
            raise ValueError(f"Invalid image type {type}")

def op(inner, type=None):
    def outer(*args_in):
        images = []
        types = []
        for args in args_in:
            if isinstance(args, tuple):
                if len(args) != 2:
                    raise ValueError("Invalid image argument")
                images.append(args[0])
                types.append(ImageType(args[1]))
            else:
                images.append(args)
                if not type is None:
                    types.append(ImageType(type))
                elif len(args.shape) == 2 and np.issubdtype(args.dtype, np.integer):
                    types.append(ImageType("class"))
                elif np.issubdtype(args.dtype, np.float):
                    types.append(ImageType("color"))
                else:
                    raise ValueError(f"Cannot deduce image type for shape {args.shape} with dtype {args.dtype}")
        images = inner(images, types)
        return tuple(images) if len(images) > 1 else images[0]
    return outer
