from .observable import Observable

import threading, time

class Thread(Observable):
    def __init__(self, interval, time_fn=time.time, run_immediately=False):
        super().__init__()
        self.time_fn = time_fn
        self.next_time = time_fn()
        if not run_immediately:
            self.next_time += interval
        self.interval = interval

        self.stop_flag = threading.Event()
        self.thread = threading.Thread(target=self.run)
        self.thread.daemon = True
        self.thread.start()

    def run(self): # TODO: what to do when self() takes longer than self.interval
        while not self.stop_flag.wait(timeout=max(self.next_time - self.time_fn(), 0)):
            self()
            self.next_time += self.interval

    def stop(self, wait=True):
        self.stop_flag.set()
        if wait:
            self.thread.join()
