class Observable:
    def __init__(self):
        self.observers = []
        self.subscribe_index = 0

    def __call__(self, *args, **kwargs):
        for observer in self.observers:
            observer[2](*args, **kwargs)

    def subscribe(self, observer, precedence=0):
        self.observers.append((precedence, self.subscribe_index, observer))
        self.observers.sort()
        self.subscribe_index += 1
        return observer

    def unsubscribe(self, observer, once=False):
        for i in range(len(self.observers)):
            if self.observers[i][2] is observer: # TODO: test
                del self.observers[i]
                if once:
                    break
        return observer
