import tinypl as pl
import pytest

def test_simple():
    stream = iter(range(0, 10))
    stream = pl.multiprocess.to_mp(stream)
    stream = pl.multiprocess.map(lambda x: x * 2, stream, workers=4)
    stream = pl.multiprocess.from_mp(stream)
    assert set(stream) == set(range(0, 20, 2))

def test_multiple():
    stream = iter(range(0, 10))
    stream = pl.multiprocess.to_mp(stream)
    stream = pl.multiprocess.map(lambda x: x * 2, stream, workers=4)
    stream = pl.multiprocess.map(lambda x: x / 2, stream, workers=4)
    stream = pl.multiprocess.map(lambda x: x * 2, stream, workers=4)
    stream = pl.multiprocess.from_mp(stream)
    assert set(stream) == set(range(0, 20, 2))

def test_worker_exception_forward():
    stream = iter(range(0, 10))
    def raise_error(x):
        raise ValueError
    stream = pl.multiprocess.to_mp(stream)
    stream = pl.multiprocess.map(raise_error, stream, workers=4, on_worker_error="forward")
    stream = pl.multiprocess.map(raise_error, stream, workers=4, on_worker_error="forward")
    stream = pl.multiprocess.map(raise_error, stream, workers=4, on_worker_error="forward")
    stream = pl.multiprocess.from_mp(stream)
    with pytest.raises(pl.multiprocess.map.WorkerException):
        for _ in stream:
            pass
