import tinypl as pl
import random, time

def test_order_queued():
    input = range(50)
    stream = iter(input)
    stream, order = pl.order.save(stream)
    stream = pl.each(lambda x: time.sleep(random.uniform(0.1, 0.01)), stream)
    stream = pl.queued(stream, workers=8)
    stream = pl.order.load(stream, order)

    assert list(stream) == list(input)

def test_order_multiprocess():
    input = range(50)
    stream = iter(input)
    stream, order = pl.order.save(stream)
    def map(x):
        time.sleep(random.uniform(0.1, 0.01))
        return x
    stream = pl.multiprocess.to_mp(stream)
    stream = pl.multiprocess.map(map, stream, workers=4)
    stream = pl.multiprocess.from_mp(stream)
    stream = pl.order.load(stream, order)

    assert list(stream) == list(input)
