import pytest
import tinypl as pl

def test_worker_exception_forward():
    stream = iter(range(0, 10))
    def raise_error(x):
        raise ValueError
    stream = pl.each(raise_error, stream)
    stream = pl.queued(stream, workers=4, on_worker_error="forward")
    stream = pl.queued(stream, workers=4, on_worker_error="forward")
    stream = pl.queued(stream, workers=4, on_worker_error="forward")
    with pytest.raises(pl.queued.WorkerException):
        for _ in stream:
            pass
