from . import stream
from .marker import MarkerItem

class each(stream.Stream):
    def __init__(self, func, input):
        super().__init__()
        self.func = func
        self.input = stream.wrap(input)

    def stop(self):
        self.input.stop()

    def next(self):
        item = stream.next(self.input)
        if not isinstance(item.get(), MarkerItem):
            self.func(item.get())
        return item
