from .item import Item
import queue

class Stream:
    def __iter__(self):
        return self

    def next_(self):
        return self.next()

    def __next__(self):
        return self.next_().get()

    def __call__(self):
        return self.__next__()

class FlattenedStream(Stream):
    def __init__(self):
        super().__init__()
        self.queue = queue.Queue()

    def __iter__(self):
        return self

    def next_(self):
        while True:
            try:
                item = self.queue.get(False)
                if item is None:
                    raise StopIteration
                else:
                    return item
            except queue.Empty:
                # Retrieve next list-of-items and add all items to queue
                items = self.next()
                for item in items:
                    assert isinstance(item, Item) or item is None
                    self.queue.put(item)

    def __next__(self):
        return self.next_().get()

    def __call__(self):
        return self.__next__()

class IteratorStream(Stream):
    def __init__(self, iterator):
        super().__init__()
        self.iterator = iterator

    def stop(self):
        self.iterator = None

    def next(self):
        return globals()["next"](self.iterator)

def next(stream_or_iterator):
    if isinstance(stream_or_iterator, Stream):
        item = stream_or_iterator.next_()
        assert isinstance(item, Item), "Expected item from " + str(type(stream_or_iterator)) + ", got " + str(type(item))
        return item
    else:
        return Item(stream_or_iterator.__next__())

def wrap(stream_or_iterator):
    if isinstance(stream_or_iterator, Stream):
        return stream_or_iterator
    else:
        return IteratorStream(stream_or_iterator)
