import cosy, math
import numpy as np
import tensorflow as tf

def test_np():
    assert np.allclose(cosy.np.angle([3, 0], [0, 1], clockwise=False), math.pi / 2)
    assert np.allclose(cosy.np.angle([1, 0], [0, -5], clockwise=False), -math.pi / 2)

def test_tf():
    angles = tf.random.uniform((1,), 0.0, 2 * math.pi, dtype="float32")
    assert tf.reduce_sum(cosy.tf.rotation_matrix_to_angle(cosy.tf.angle_to_rotation_matrix(angles)) - angles) < 1e-4
