import os, tfcv, imageio

class Frame:
    def __init__(self, images, frame_id):
        self.images = images
        self.id = frame_id

class FrameId:
    def __init__(self, files):
        self.files = files

    def load(self):
        images = [imageio.imread(f) for f in self.files]
        return Frame(images, self)

def load(*paths):
    files = []
    for path in paths:
        files.append(sorted([os.path.join(path, f) for f in os.listdir(path) if tfcv.data.util.is_image_file(f)]))
    file_nums = [len(l) for l in files]
    if len(set(file_nums)) != 1:
        raise IOError(f"Got different number of files {file_nums} in given folders")

    frame_ids = [FrameId(files) for files in zip(*files)]
    return frame_ids
