import numpy as np

# https://github.com/TUI-NICR/ESANet/blob/c78365f8688e974b66302520e8257763a2d755f6/src/datasets/nyuv2/nyuv2.py#L8
def _get_colormap(n):
    def bitget(byteval, idx):
        return (byteval & (1 << idx)) != 0

    cmap = np.zeros((n, 3), dtype='uint8')
    for i in range(n):
        r = g = b = 0
        c = i
        for j in range(8):
            r = r | (bitget(c, 0) << 7-j)
            g = g | (bitget(c, 1) << 7-j)
            b = b | (bitget(c, 2) << 7-j)
            c = c >> 3

        cmap[i] = np.array([r, g, b])

    return cmap

# CLASS_COLORS_13 = [[0, 0, 0],
#                    [0, 0, 255],
#                    [232, 88, 47],
#                    [0, 217, 0],
#                    [148, 0, 240],
#                    [222, 241, 23],
#                    [255, 205, 205],
#                    [0, 223, 228],
#                    [106, 135, 204],
#                    [116, 28, 41],
#                    [240, 35, 235],
#                    [0, 166, 156],
#                    [249, 139, 0],
#                    [225, 228, 194]]

class_to_color = _get_colormap(1 + 40)[1:, :].tolist()
# CLASS_COLORS_894 = _get_colormap(1 + 894).tolist()
