import inspect
import numpy as np

def array(arg, name, shape=None, dtype=None):
    if not shape is None:
        shape = np.asarray(shape)
    if callable(arg):
        params = inspect.signature(arg).parameters.keys()
        kwargs = {}
        if "shape" in params:
            if shape is None:
                raise ValueError("shape cannot be None when callable is passed that requires shape argument")
            kwargs["shape"] = shape
        arg = arg(**kwargs)
    arg = np.asarray(arg)
    if not shape is None:
        arg = np.broadcast_to(arg, shape)

    if not dtype is None:
        arg = arg.astype(dtype)
    return arg

def array_like(arg, name, images, dtype=None):
    ndim = min([i.ndim for i in images])
    arg = array(arg, name=name, shape=images[0].shape[:ndim], dtype=dtype)
    return arg

def dims(arg, name, ndim=None, images=None, dtype=None):
    if ndim is None:
        ndim = min([i.ndim for i in images])
    arg = array(arg, name, shape=(ndim,), dtype=dtype)
    if arg.ndim > 1:
        raise ValueError(f"Got invalid {name} argument {arg}")
    return arg
