from .observable import Observable

class Counter(Observable):
    def __init__(self, period=1, start_value=0):
        super().__init__()
        self.counter = start_value
        self.period = period
        self.done_periods = 0

    def reset(self, hard=False):
        if hard:
            self.counter = 0
            self.done_periods = 0
        else:
            self.counter = 0
            self.done_periods += 1

    def get(self):
        return self.done_periods

    def remaining(self):
        return self.period - self.counter

    def __call__(self, *args, **kwargs):
        self.counter += 1
        if self.counter >= self.period:
            Observable.__call__(self, *args, **kwargs)
            self.counter = 0
            self.done_periods += 1
