from . import stream
from .marker import MarkerItem

class filter(stream.Stream):
    def __init__(self, pred, input):
        super().__init__()
        self.pred = pred
        self.input = stream.wrap(input)

    def stop(self):
        self.input.stop()

    def next(self):
        while True:
            item = stream.next(self.input)
            if isinstance(item.get(), MarkerItem) or self.pred(item.get()):
                return item
