from . import stream
import queue, threading
from .marker import MarkerItem

class flatten(stream.Stream):
    def __init__(self, input):
        super().__init__()
        self.input = stream.wrap(input)
        self.next_items = queue.Queue()
        self.stopped = False

    def stop(self):
        self.input.stop()

        # Clear queue
        while not self.next_items.empty():
            try:
                self.next_items.get(False)
            except queue.Empty:
                continue
            self.next_items.task_done()

        self.stopped = True

    def next(self):
        while not self.stopped:
            try:
                return self.next_items.get(False)
            except queue.Empty:
                item = stream.next(self.input)
                if not isinstance(item.get(), MarkerItem):
                    for subitem_value in item.get():
                        self.next_items.put(item.new(subitem_value))
                    item.drop()
                else:
                    self.next_items.put(item)
        raise StopIteration
