from . import stream, util
import threading

class MarkerItem:
    def __init__(self, source):
        self.source = source

class after_each_(stream.FlattenedStream):
    def __init__(self, input, after_markers=False):
        super().__init__()
        self.input = stream.wrap(input)
        self.after_markers = after_markers

    def stop(self):
        self.input.stop()

    def next(self):
        item = stream.next(self.input)
        if not isinstance(item.get(), MarkerItem) or self.after_markers:
            marker_item = item.new(MarkerItem(util.id(self)))
            return [item, marker_item]
        else:
            return [item]

def after_each(stream):
    stream = after_each_(stream)
    return stream, util.id(stream) # Interpret as (stream, marker)

# Must consume marker
class until(stream.Stream):
    def __init__(self, input, marker=None):
        super().__init__()
        self.input = stream.wrap(input)
        self.source = marker
        self.end = False
        self.lock = threading.Lock()

    def stop(self):
        self.input.stop()

    def next(self):
        with self.lock:
            if self.end:
                raise StopIteration
            item = stream.next(self.input)
            if isinstance(item.get(), MarkerItem) and (self.source is None or item.get().source == self.source):
                self.end = True
                raise StopIteration
            else:
                return item

class on(stream.FlattenedStream):
    def __init__(self, func, input, marker=None, consume=False):
        super().__init__()
        self.func = func
        self.input = stream.wrap(input)
        self.source = marker
        self.consume = consume

    def stop(self):
        self.input.stop()

    def next(self):
        item = stream.next(self.input)
        if isinstance(item.get(), MarkerItem) and (self.source is None or item.get().source == self.source):
            self.func()
            if self.consume:
                return []
            else:
                return [item]
        else:
            return [item]
