from . import stream
from .marker import MarkerItem
from .item import Item
import traceback, os

class MarkerNotAllowedException(Exception):
    pass

class partition(stream.FlattenedStream):
    def __init__(self, num, input, markers=None, marker_splits_batch=False): # TODO: check order of args everywhere, input first or rest first?
        super().__init__()
        self.num = num
        self.input = stream.wrap(input)
        self.tb = "".join(traceback.format_stack()[:-1])
        if not (markers is None or markers == "after" or markers == "before"):
            raise ValueError("markers parameter must be one of None, 'before' and 'after'")
        self.markers = markers
        self.marker_splits_batch = marker_splits_batch

    def stop(self):
        self.input.stop()

    def next(self):
        after_markers = []
        items = []
        def make_item():
            return Item([item.get() for item in items]) # TODO: keep annotations in partition that are recovered in flatten?
        while True:
            try:
                item = stream.next(self.input)
            except StopIteration:
                if len(items) > 0:
                    yield make_item()
                for markers in after_markers:
                    yield markers
                yield None
                return
            if isinstance(item.get(), MarkerItem):
                if self.markers is None:
                    raise MarkerNotAllowedException("Markers not allowed at:\n" + str(self.tb))
                elif self.markers == "after":
                    if len(items) == 0:
                        yield item
                    else:
                        after_markers.append(item)
                else:
                    assert self.markers == "before"
                    yield item
                if self.marker_splits_batch:
                    if len(items) > 0:
                        yield make_item()
                        for marker in after_markers:
                            yield marker
                        break
            else:
                items.append(item)
                if len(items) == self.num:
                    yield make_item()
                    for marker in after_markers:
                        yield marker
                    break
