%% Part I: speed of light & temporal resolution
% 1.1 speed of light
c = 3E8;
% 1.2 temporal resolution
delta_t = 32E-12;

%% Part II: size and location of the reconstruction domain
% 2.1 size of a basic voxel
bx = c * delta_t; by = 2/63; bz = 2/63;
% 2.2 location of the reconstruction domain
xb = 1.2; yb = 0; zb = 0;
xe = 1.5; ye = 2; ze = 2;
% 2.3 number of voxels extended for reconstruction
ext_x = 0; ext_y = 0; ext_z = 0;
% 2.4 number of basic voxels in each inversion voxel
nbx = 1; nby = 1; nbz = 1;

% compute the size of the extended reconstruction domain 
xb = xb - nbx * bx * ext_x; yb = yb - nby * by * ext_y; zb = zb - nbz * bz * ext_z;
xe = xe + nbx * bx * ext_x; ye = ye + nby * by * ext_y; ze = ze + nbz * bz * ext_z;

% compute the index of voxels in three dimensions
xbc = floor(xb / bx); ybc = floor(yb / by); zbc = floor(zb / bz);
xec = ceil (xe / bx); yec = ceil (ye / by); zec = ceil (ze / bz);

% compute the number of voxels in each dimension 
xg = xbc:nbx:xec; lxs = length(xg);
yg = ybc:nby:yec; lys = length(yg);
zg = zbc:nbz:zec; lzs = length(zg);

% number of inversion voxels in total
num_voxel = lxs * lys * lzs;