function isscp(sub_Sig_1, C_i_1, sub_Sig_2, C_i_2, yg, zg, pause_flag)
lys = length(yg);
lzs = length(zg);
[num_meas_1, num_bin] = size(sub_Sig_1);
[num_meas_2, ~] = size(sub_Sig_2);

X_1 = NaN * zeros(lys,lzs,num_bin);
X_2 = NaN * zeros(lys,lzs,num_bin);

for s = 1:num_meas_1
    temp_sig = sub_Sig_1(s,:);
    temp_y_ind = C_i_1(s,2);
    temp_z_ind = C_i_1(s,3);
    X_1(yg == temp_y_ind,zg == temp_z_ind,:) = temp_sig;
end

for s = 1:num_meas_2
    temp_sig = sub_Sig_2(s,:);
    temp_y_ind = C_i_2(s,2);
    temp_z_ind = C_i_2(s,3);
    X_2(yg == temp_y_ind,zg == temp_z_ind,:) = temp_sig;
end

X_1 = X_1 ./ max(X_1(:)) * 255;
X_2 = X_2 ./ max(X_2(:)) * 255;

figure
for bin = 1:num_bin
    subplot(1,2,1)
    temp_img = rot90(X_1(:,:,bin));
    if max(temp_img(:)) == 0, continue, end 
    h = imagesc(temp_img);
    title(num2str(bin))
    caxis([0 255])
    colormap('jet')
    axis square
    set(h,'alphadata',~isnan(temp_img));
    set(gca,'color',[0 0 0]);
    set(gca,'xtick',[]), set(gca,'ytick',[])
    
    subplot(1,2,2)
    temp_img = rot90(X_2(:,:,bin));
    h = imagesc(temp_img);
    title(num2str(bin))
    caxis([0 255])
    colormap('jet')
    axis square
    set(h,'alphadata',~isnan(temp_img));
    set(gca,'color',[0 0 0]);
    set(gca,'xtick',[]), set(gca,'ytick',[])
    
    if pause_flag == 1
        pause;
    else
        pause(0.01)
    end
    
end
end