function y = three(albedo, temp_name)

min_albedo = 0; 
max_albedo = max(albedo(:));

% front view
    figure('Position',[50 50+400 320 320])
    axes('Position',[0 0 1 1])
    temp_img = rot90(squeeze(max(albedo,[],1)));
    temp_img = temp_img(:,end:-1:1);
    imagesc(temp_img);
    colormap('hot');
    caxis([min_albedo, max_albedo])
    axis equal;
    axis off
%     saveas(gcf,[temp_name, 'front_view.png'])

% top view  
    figure('Position',[50+320 50+400 320 320])
    axes('Position',[0 0 1 1])
    temp_img = squeeze(max(albedo,[],3));
    temp_img = temp_img(end:-1:1,end:-1:1);
    imagesc(temp_img);
    colormap('hot');
    caxis([min_albedo, max_albedo])
    axis equal;
    axis off
%     saveas(gcf,[temp_name, 'top_view.png'])

% side view
    figure('Position',[50+320+320 50+400 320 320])
    axes('Position',[0 0 1 1])
    temp_img = rot90(squeeze(max(albedo,[],2)));
    imagesc(temp_img);
    colormap('hot');
    caxis([min_albedo, max_albedo])
    axis equal;
    axis off
%     saveas(gcf,[temp_name, 'side_view.png'])
    y = [];
end