function y = bfun(x,opt,lambda,w)
% x
% opt
% lambda: matrix
% w: W_{ij} = w_i + w_j
% d:vector, right hand side.

% if strcmp(flag,'notransp') % Compute A*x
% elseif strcmp(flag,'transp') % Compute A'*x
% end

%% length of x
lx = length(x);
m = sqrt(lx);
x = reshape(x,m,m);

w = 2 * w;
w = w * x;

%% data fidelity
y = lambda .* x;

%% regularization

% top left
y(1,1) = y(1,1) + 3 * w(1,1) - w(1,2) - w(2,1) - w(2,2);

% top right 
y(1,end) = y(1,end) + 3 * w(1,end) - w(1,end - 1) - w(2,end - 1) - w(2,end);

% bottom left
y(end,1) = y(end,1) + 3 * w(end,1) - w(end-1,1) - w(end-1,2) - w(end,2);

% bottom right
y(end,end) = y(end,end) + 3 * w(end,end) - w(end-1,end-1) - w(end-1,end) - w(end,end-1);

% top
for j = 2 : m-1
    y(1,j) = y(1,j) + 5 * w(1,j) - w(1,j-1) - w(1,j+1) - w(2,j-1) - w(2,j) - w(2,j+1);
end

% bottom
for j = 2 : m-1
    y(end,j) = y(end,j) + 5 * w(end,j) - w(end,j-1) - w(end,j+1) - w(end-1,j-1) - w(end-1,j) - w(end-1,j+1);
end

% left
for j = 2 : m-1
    y(j,1) = y(j,1) + 5 * w(j,1) - w(j-1,1) - w(j+1,1) - w(j-1,2) - w(j,2) - w(j+1,2);
end

% right
for j = 2 : m-1
    y(j,end) = y(j,end) + 5 * w(j,end) - w(j-1,end) - w(j+1,end) - w(j-1,end-1) - w(j,end-1) - w(j+1,end-1);
end

for j = 2 : m-1
    for k = 2 : m-1
        y(j,k) = y(j,k) + 8 * w(j,k) - w(j-1,k-1) - w(j-1,k) - w(j-1,k+1)...
                 - w(j,k-1) - w(j,k+1)...
                 - w(j+1,k-1) - w(j+1,k) - w(j+1,k+1);
    end
end
y = y(:);