function U = structural_sparsity(u_input,Sig_flag,xmin_i,ymin_i,zmin_i,xmin_d,ymin_d,zmin_d, xg,yg,zg, C_i,C_d, Arr_bin_i,Arr_bin_d, max_col, threshold_value)
[lxs,lys,lzs,num_meas] = size(u_input);
U = NaN * zeros(lxs,lys,lzs,num_meas);
for s = 1:num_meas
    u = u_input(:,:,:,s);
    if Sig_flag(s) == 0, continue, end
    id_ind_i = C_i(s,:); id_ind_d = C_d(s,:);
    temp_Arr_i = Arr_bin_i(xg - id_ind_i(1) - xmin_i + 1, yg - id_ind_i(2) - ymin_i + 1, zg - id_ind_i(3) - zmin_i + 1);
    temp_Arr_d = Arr_bin_d(xg - id_ind_d(1) - xmin_d + 1, yg - id_ind_d(2) - ymin_d + 1, zg - id_ind_d(3) - zmin_d + 1);
    temp_Arr = ceil(temp_Arr_i + temp_Arr_d);
%% Determining range
    temp_Arr = temp_Arr(:); min_Arr = min(temp_Arr); max_Arr = max(temp_Arr); max_range = max_Arr - min_Arr + 1;
%% Processing
    temp_Data = zeros(max_range,max_col);
    Num_vox = NaN * zeros(max_range,1);
    Order_u = NaN * zeros(max_range,max_col);
    for num_arr = min_Arr : max_Arr
        temp_index = num_arr - min_Arr + 1;
        f = find(temp_Arr == num_arr); 
        Num_vox(temp_index) = length(f);
        [temp_u_value, temp_u_order] = sort(u(f),'descend');
        Order_u(temp_index, 1:Num_vox(temp_index)) = temp_u_order;
        temp_Data(temp_index, 1:Num_vox(temp_index)) = temp_u_value;
        pause(0.001)
    end
    temp_Data = temp_Data(:,1:max(Num_vox));
    Order_u = Order_u(:,1:max(Num_vox));
    preserve_num = sum( sum(temp_Data,1) > threshold_value );
    temp_u = u;
    if preserve_num == 0
        temp_u(u~=0) = 0;
    else
       for num_arr = min_Arr : max_Arr
           temp_index = num_arr - min_Arr + 1;
           f = find(temp_Arr == num_arr);
           temp_u(f(Order_u(temp_index, preserve_num + 1 : Num_vox(temp_index)))) = 0;
           pause(0.001)
       end
    end
    U(:,:,:,s) = temp_u;
end
end