function vs(u)
%% maximum albedo value projection
alb = cpt_alb(u);                                    % compute albedo
max_alb = max(alb(:));                               % maximum albedo value
u = u / max_alb;                                     % normalization
alb = alb / max_alb;                                 % normalization
max_alb_ind = get_max_alb_ind(alb);                  % find the depth index with maximum albedo value
max_u_proj = get_proj_u(u,max_alb_ind);              % get maximum directional volume projection
max_alb_proj = get_proj_alb(alb,max_alb_ind);        % get maximum albedo projection

% show albedo
show_2D_insp(r(max_alb_proj), [50,200,320,400]);

% show 
show_2D_insp(r(max_u_proj(:,:,1)), [370 + 10,200,320,400]);
show_2D_insp(r(max_u_proj(:,:,2)), [370+320 + 20,200,320,400]);
show_2D_insp(r(max_u_proj(:,:,3)), [370+320+320 + 30,200,320,400]);

% close figures
pause
cl
end